// connectionplayer
// oswald berthold 10/2007
// plays sounds correlating to network connections
// version 2. known ports get special treatment
// oswald berthold, 10/2007

// init
(
Server.default = s = Server.local;
s.boot;
g = SwingOSC.default;
g.boot;
)

(

~hostaction = {
	|t,r,m|
	var ip = m[1].asString.split($.);
	ip.postln;
	m.postln;
	Synth(\host1, [
		\a1, ip[0].asInteger,
		\a2, ip[1].asInteger,
		\a3, ip[2].asInteger,
		\a4, ip[3].asInteger, \localflag]);
};

~hostresp = OSCresponder(nil, "/host", ~hostaction).add;
~newhostresp = OSCresponder(nil, "/new/host", ~hostaction).add;

~portcheck = {|sport, dport|
	var knownports = Dictionary[
		21 -> 'ftp',
		22 -> 'ssh',
		25 -> 'smtp',
		53 -> 'domain',
		80 -> 'http',
		110 -> 'pop3',
		123 -> 'ntp',
		143 -> 'imap',
		443 -> 'https',
		993 -> 'pops',
		995 -> 'imaps',
		1194 -> 'openvpn',
		3306 -> 'mysql',
		8000 -> 'icecast',
		8080 -> 'http',
		10000 -> 'webmin'];
	var match;
	if((match = knownports.matchAt(sport)) != nil) {
		//["sport", match].postln;
		match
	} {
		if((match = knownports.matchAt(dport)) != nil) {
			//["dport", match].postln;
			match
		} { nil };
	};
};

// ~portcheck.value(1, 2)

~connaction = {
	|t,r,m|
	var sip = m[1].asString.split($.).asInteger;
	var dip = m[3].asString.split($.).asInteger;
	//[sip, dip].postln;
	var port = ~portcheck.value(m[2], m[4]);
	var proto = m[5];
	var plen = m[8];
	if(proto == 6) {
		plen = plen / m[7]; // average packetlength on connection
	};
	if(port != nil) {
		[("conn" ++ port.asString), plen].postln;
		Synth("conn" ++ port.asString, [
			//\s1, sip[0].asInteger, \s2, sip[1].asInteger, \s3, sip[2].asInteger, \s4, sip[3].asInteger, \sport, m[2]/65535,
			//\d1, dip[0].asInteger, \d2, dip[1].asInteger, \d3, dip[2].asInteger, \d4, dip[3].asInteger, \dport, m[4]/65535,
			\s1, sip[0], \s2, sip[1], \s3, sip[2], \s4, sip[3], \sport, m[2]/65535,
			\d1, dip[0], \d2, dip[1], \d3, dip[2], \d4, dip[3], \dport, m[4]/65535,
			\proto, m[5], \plen, plen
		]);
	} {
		//["nix bekannt"].postln;
		Synth(\conn1, [
			//\s1, sip[0].asInteger, \s2, sip[1].asInteger, \s3, sip[2].asInteger, \s4, sip[3].asInteger, \sport, m[2]/65535,
			//\d1, dip[0].asInteger, \d2, dip[1].asInteger, \d3, dip[2].asInteger, \d4, dip[3].asInteger, \dport, m[4]/65535,
			\s1, sip[0], \s2, sip[1], \s3, sip[2], \s4, sip[3], \sport, m[2]/65535,
			\d1, dip[0], \d2, dip[1], \d3, dip[2], \d4, dip[3], \dport, m[4]/65535,
			\proto, m[5]
		]);
	};
	// XXX: wenn viele pakete, lautstaerke runter
};

~connresp = OSCresponder(nil, "/connection", ~connaction).add;
~newconnresp = OSCresponder(nil, "/new/connection",	~connaction).add;

~delaction = {
	|t,r,m|
	m.postln;
};

~delconnresp = OSCresponder(nil, "/delete/connection", ~delaction).add;
~delhostresp = OSCresponder(nil, "/delete/host", ~delction).add;
)

// stop it
(
~hostresp.remove;
~newhostresp.remove;
~connresp.remove;
~newconnresp.remove;
~delconnresp.remove;
~delhostresp.remove;
)

// synths
(
SynthDef(\host1, {
	|a1(0), a2(0), a3(0), a4(0), localflag(0)|
	var fscale = 2;
	var snd = Mix([
		SinOsc.ar(a1 * fscale, 0, 0.1),
		SinOsc.ar(a2 * fscale, 0, 0.1),
		SinOsc.ar(a3 * fscale, 0, 0.1),
		SinOsc.ar(a4 * fscale, 0, 0.1),
	]);
	Out.ar(0, Pan2.ar(snd * Linen.kr(Impulse.ar(0), 0.001, 1.0, 0.1, doneAction: 2), 0));
}).send(s);

SynthDef(\conn1, {
	|s1, s2, s3, s4, sport, d1, d2, d3, d4, dport, proto|
	// ports: 123, 1194
	var fscale = 10;
	var foffs = 0;
	var len = 0.6;
	var mod = SinOsc.ar(Line.ar(sport, dport, len, 100, 0), 0, 100);
	var snd = Mix([
		SinOsc.ar(Line.ar(s1, d1, len, mul: fscale, add: foffs) + mod, 0, 0.02),
		SinOsc.ar(Line.ar(s2, d2, len, mul: fscale, add: foffs) + mod, 0, 0.02),
		SinOsc.ar(Line.ar(s3, d3, len, mul: fscale, add: foffs) + mod, 0, 0.02),
		SinOsc.ar(Line.ar(s4, d4, len, mul: fscale, add: foffs) + mod, 0, 0.02),
	]);
	Out.ar(0, Pan2.ar(snd * Linen.kr(Impulse.ar(0), 0.001, 1.0, len - 0.001, doneAction: 2), 0));
}).send(s);

// bekannte ports
// formant
// Formlet
// birds
// frequenzmodulierte rechteckschwingung
// Select
SynthDef(\connssh, { // XXX
	|s1, s2, s3, s4, sport, d1, d2, d3, d4, dport, proto, plen|
	var len = sport + dport * plen / 1000;
	var snd = Select.ar(LFSaw.kr(len.reciprocal, pi, 4, 4),
		[
			Pulse.ar(s1 + 100, 0.5),
			Pulse.ar(s2 + 100, 0.5),
			Pulse.ar(s3 + 100, 0.5),
			Pulse.ar(s4 + 100, 0.5),
			Pulse.ar(d1 + 100, 0.5),
			Pulse.ar(d2 + 100, 0.5),
			Pulse.ar(d3 + 100, 0.5),
			Pulse.ar(d4 + 100, 0.5)
		]
	);
	Out.ar(0, Pan2.ar(snd * Linen.kr(Impulse.ar(1), 0.001, 0.5, len, doneAction: 2), 0));
}).send(s);

/* (
Synth(\connssh, [
	\s1, 1, \s2, 10, \s3, 100, \s4, 200, \sport, 1,
	\d1, rrand(0,255).asInteger, \d2, rrand(0, 255).asInteger, \d3, 50, \d4, 159 , \dport, 8,
	\proto, 6, \plen, 64
]).send(s);
*/)


SynthDef(\connhttp, { // XXX
	|s1, s2, s3, s4, sport, d1, d2, d3, d4, dport, proto, plen|
	var snd = Formant.ar(
		XLine.kr(s1 + 1 * 10,s2 + 1 * 10, 0.1), // basefreq
		s3 + 1 * 10, // formant freq
		s4 + 1 * 10, // formant bandwidth
		EnvGen.kr(Env.perc(0.001, 0.1, 0.1, -4), 1, 1.0, 0.0, 1.0, doneAction: 2));
	var snd2 = Formant.ar(
		XLine.kr(d1 + 1 * 10,d2 + 1 * 10, 0.1), // basefreq
		d3 + 1 * 10, // formant freq
		d4 + 1 * 10, // formant bandwidth
		EnvGen.kr(Env.perc(0.001, 0.1, 0.1, 4), 1, 1.0, 0.0, 1.0, doneAction: 2));
	Out.ar(0, Pan2.ar(snd + snd2, 0));
}).send(s);

SynthDef(\conndomain, { // XXX
	|s1, s2, s3, s4, sport, d1, d2, d3, d4, dport, proto, plen|
	var len = sport + dport * plen / 200;
	var snd = Pulse.ar(Line.kr(s1, d1, len, 10, 100), 0.5, 
		Linen.kr(Impulse.ar(1), 0.001, 0.1, len, doneAction: 2)
	);
	Out.ar(0, Pan2.ar(snd, 0));
}).send(s);

SynthDef(\connntp, { // XXX
	|s1, s2, s3, s4, sport, d1, d2, d3, d4, dport, proto, plen|
	var len = sport + dport * plen / 200;
	var snd1 = Blip.ar(s1, 4, Linen.kr(Impulse.ar(1), 0.001, 0.1, len, doneAction: 2));
	var snd2 = Blip.ar(s2, 4, Linen.kr(Impulse.ar(1, s2/255), 0.001, 0.1, len, doneAction: 2));
	var snd3 = Blip.ar(s3, 4, Linen.kr(Impulse.ar(1, s3/255), 0.001, 0.1, len, doneAction: 2));
	var snd4 = Blip.ar(s4, 4, Linen.kr(Impulse.ar(1, s4/255), 0.001, 0.1, len, doneAction: 2));
	var snd5 = Blip.ar(d1, 4, Linen.kr(Impulse.ar(1), 0.001, 0.1, len, doneAction: 2));
	var snd6 = Blip.ar(d2, 4, Linen.kr(Impulse.ar(1, d2/255), 0.001, 0.1, len, doneAction: 2));
	var snd7 = Blip.ar(d3, 4, Linen.kr(Impulse.ar(1, d3/255), 0.001, 0.1, len, doneAction: 2));
	var snd8 = Blip.ar(d4, 4, Linen.kr(Impulse.ar(1, d4/255), 0.001, 0.1, len, doneAction: 2));
	Out.ar(0, Pan2.ar(Mix(snd1, snd2, snd3, snd4, snd5, snd6, snd7, snd8), 0));
}).send(s);

SynthDef(\connopenvpn, { // XXX
	|s1, s2, s3, s4, sport, d1, d2, d3, d4, dport, proto, plen|
	var snd1 = Klang.ar(`[[s1, s2, s3, s4], [1.0, 0.7, 0.5, 0.3], nil], 1.0, sport * 20000.0);
	var snd2 = Klang.ar(`[[d1, d2, d3, d4], [1.0, 0.7, 0.5, 0.3], nil], 1.0, dport * 20000.0);
	Out.ar(0, Pan2.ar((snd1 + snd2) * Linen.kr(Impulse.ar(0), 0.001, 0.1, sport + dport * plen / 200, doneAction: 2), 0));
}).send(s);


// XXX
// icons fuer bekannte services
)

Synth(\host1, [\a1, 100, \a2, 200, \a3, 300, \a4, 400]);

(
Synth(\conn1, [
	\s1, 100, \s2, 200, \s3, 150, \s4, 50, \sport, 1000,
	\d1, 200, \d2, 100, \d3, 50, \d4, 159 , \dport, 8000,
	\proto, 6
]);
)

(
Synth(\connopenvpn, [
	\s1, 100, \s2, 200, \s3, 150, \s4, 50, \sport, 1,
	\d1, 200, \d2, 100, \d3, 50, \d4, 159 , \dport, 8,
	\proto, 6
]);
)

(
Synth(\connhttp, [
	\s1, 193, \s2, 12, \s3, 150, \s4, 50, \sport, 1,
	\d1, 200, \d2, 100, \d3, 50, \d4, 159 , \dport, 8,
	\proto, 6
]);
)

(
Synth(\conndomain, [
	\s1, 193, \s2, 12, \s3, 150, \s4, 50, \sport, 1,
	\d1, 200, \d2, rrand(0, 255).asInteger, \d3, 50, \d4, 159 , \dport, 8,
	\proto, 6
]);
)
